"use client"
import Image from 'next/image'
import styles from './header.module.css'
import { useEffect, useState } from 'react';
import axios from 'axios'
import parse from 'html-react-parser';



export default function Footer() {

  const [data,setData]=useState([])


  function ckEditorCheck() {
    document.querySelectorAll('.ck-content .image_resized').forEach(e=>{
      if (e.querySelector('figcaption')) {
        if(e.querySelector('figcaption')?.innerHTML=='left'){
          e.classList.remove('image-style-side')
          e.classList.add('image-style-align-left')
        }

      }
  })
  }
  async function getData() {
    const dataResponse = await axios.get('https://pixelfcty.com/api/footers')
    const data = dataResponse.data.data
    console.log('footer',data);
    setData(data)
  }  
  useEffect( () => {
    getData()
    
    ckEditorCheck()
  }, [1]);
  const validateEmail = (email) => {
    return String(email)
      .toLowerCase()
      .match(
        /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|.(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
      );
  };

  async function sendformContact() {
    
    let email = document.querySelector('.footeremail').value

    if (validateEmail(email)) {
      const dataResponse = await axios.post('https://pixelfcty.com/api/contacts',{data:{
        email:email,
        company:"footer Subscription"
      }})
      alert('thanks for sending document, we will send message to you soon.')
      document.querySelector('.footeremail').value = ''
    }
    else alert("Email is not Correct")
    

  }
  return (
    <>
      <footer>
        <div className="container footer">
          <div className="row">
          {/* <div className="col-12 col-md-2">
              <h4>Learn</h4>
              <ul>
                <li>About Invest Oman</li>
                <li>About Oman</li>
                <li>Why Oman</li>
                <li>Success Stories</li>
              </ul>
            </div>
            <div className="col-12 col-md-2">
              <h4>Explore</h4>
              <ul>
                <li>Opportunnity Explorer</li>
                <li>Investment Key Sectors</li>
                <li>How can we Help?</li>
                <li>Privacy Policy</li>
                <li>FAQs</li>
              </ul>
            </div>
            <div className="col-12 col-md-2">
              <h4>Exprience</h4>
              <ul>
                <li>News</li>
                <li>Events</li>
              </ul>
            </div>
            <div className="col-12 col-md-2">
              <h4>Connect</h4>
              <ul>
                <li>Ministry of Commerce</li>
                <li>Industry & Invest</li>
                <li>Promotion</li>
                <li>Oman Investment Authority</li>
                <li>Muscat Securities Market</li>
                <li>Ministry of Economy</li>
              </ul>
            </div>
            <div className="col-12 col-md-4 text-center ">
              <h4>Our Newsletter</h4>
              <h5>subscribe Today</h5>
              <hr />
              <input type="email" className='footeremail' name='email' placeholder='Enter Your Email' />
              <button onClick={sendformContact}>subscribe</button>
            </div> */}
            {data.length!=0?
              data.map(e=>(
                <div key={e.id} className="col">
                <h4>{e.attributes.title}</h4>
                <div>
                  {parse(e.attributes.body)}
                </div>
              </div>
              ))
              :''
            }
          </div>
        </div>
      </footer>
    </>
  )
}
