"use client"
import Image from 'next/image'
import axios from 'axios'
import { useEffect, useState } from 'react';
import parse from 'html-react-parser';
import Link from 'next/link'
import Footer from '../components/footer'
import Header from '../components/header'
import '../globals.css'
import 'bootstrap/dist/css/bootstrap.css'
import { useParams } from 'next/navigation'
import Loader from '../components/loader';
import Head from 'next/head'



const Home = ()=>{
const [data,setData]=useState([])
const [loaded,setLoaded]= useState(false)
const [hasSlider,setHasSlider]=useState(false)



async function getData() {
    const dataResponse = await axios.get('https://pixelfcty.com/api/news?populate=deep')
    const data = dataResponse.data.data
    setData(data)  
    console.log(data[0].attributes.slug);
  }



useEffect(() => { 
  getData()
  setTimeout(() => {
    setLoaded(true)
  }, 1000);
}, [1])

  return (
    <>
        <Head>
      <title>Aljaber Holding | News</title>
    </Head>
    {!loaded?

        <Loader></Loader>
    :
    <main >
            <div className='companyPage'>
      <Header iswhite={hasSlider} />
      </div>

      <div className="container home-projects mt-10">
        <div className="row">
          {
            data.length!=0?
            data.map(e=>(
              <div key={e.id} className="col-md-4 home-project">
                <Link  href={'/news/'+e.attributes.slug}>
                  
              <div className="cart">
                <img alt='dd' src={'https://pixelfcty.com'+ e['attributes']['picture']['data']['attributes']['url']} width={200} height={200}></img>
                <h3>{ e['attributes']['title']}</h3>
              </div>
              </Link>
            </div>
             
            )):''
          }


        </div>
      </div>

          <Footer/>
    </main>
        }
        </>
  )
}




export default Home;