"use client"
import Image from 'next/image'
import Header from './components/header'
import axios from 'axios'
import { useEffect, useState } from 'react';
import parse from 'html-react-parser';
import Link from 'next/link'
import Footer from './components/footer'
import './globals.css'
import 'bootstrap/dist/css/bootstrap.css'
import CountUp from 'react-countup';
import Head from 'next/head';
import Loader from './components/loader';


const Home = ()=>{
const [data,setData]=useState()
const [loaded,setLoaded]= useState(false)
const [companies,setCompanies] = useState([])

async function getData() {
  const dataResponse = await axios.get('https://pixelfcty.com/api/pages?filters[slug][$eq]=home&populate=deep')
  const data = dataResponse.data.data[0]
  const conpanyResponse = await axios.get('https://pixelfcty.com/api/companies?filters[for_home]&sort=order&populate=deep')
  const company = conpanyResponse.data.data
  setData(data)  
  console.log('compan',company);
  
  setCompanies(company)
}
  useEffect(() => {  
    getData()  
    setTimeout(() => {
      setLoaded(true)
    }, 1000);
  }, [])

  function socialToggle(){
    document.querySelector('.social-media-icon')?.classList.add('social-media-icon-active')
  }

  return (
    <>
            <Head>
      <title>Aljaber Holding</title>
    </Head>
    {!loaded?

        <Loader></Loader>
    :
    <main >
    <Header iswhite={true}/>
    <ul className='headerButtons'>
              <a href='#aljaber'><li><span className='headerButton key1'>about Aljaber Holding</span></li></a>
              <a href='#our'><li><span className='headerButton key2'>Our Companies</span></li></a>
              <a href='#counter'><li><span className='headerButton key3'>Counter</span></li></a>
              <a href='#footer'><li><span className='headerButton key4'>footer</span></li></a>
            </ul>
    <div className="container-fluid p-0 m-0 overflow-hidden">
      <div className="row ">
        <div className="col-sm-12 header-video">
            <img className='social-media' onMouseEnter={socialToggle}   src="social-media.png" alt="" />
            <ul className='social-media-icon '>
              <li><a href='#'><img  src="instagram.png" alt="" /></a></li>
              <li><a href='#'><img  src="facebook.png" alt="" /></a></li>
              <li><a href='#'><img  src="whatsapp.png" alt="" /></a></li>
              <li><a href='#'><img  src="telegram.png" alt="" /></a></li>

            </ul>
          <div id="carouselExampleIndicators" className="carousel slide">

            <div className="carousel-inner">
              
            {data?
              data['attributes']['slider'].map((e,index)=>(
                <div key={e.id} className={`carousel-item ${index==0?'active':''}`}>
                <video  src={'https://pixelfcty.com/'+e['media']['data']['attributes']['url']}  muted autoPlay preload='true' loop className="d-block w-100">
                  Your browser does not support the video tag.
                </video>    
                </div>                ))
              :''
            }


            </div>
            <button className="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
              <span className="carousel-control-prev-icon" aria-hidden="true"></span>
              <span className="visually-hidden">Previous</span>
            </button>
            <button className="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
              <span className="carousel-control-next-icon" aria-hidden="true"></span>
              <span className="visually-hidden">Next</span>
            </button>
          </div>

        </div>
      </div>
    </div>
    <div className="container-fluid sections d-none d-lg-block px-10">
    <div className="row ">
    <Link className='white' legacyBehavior href="/development"><div className="col-6 col-md-3 section"><span className='bigChar red' >D</span>evelopment & Investment</div></Link>
    <Link className='white' legacyBehavior href="/construction"><div className="col-6 col-md-2 section"><span className='bigChar grey' >C</span>onstruction</div></Link>
  
      <Link className='white' legacyBehavior href="/consultant"><div className="col-6 col-md-2 section"><span className='bigChar yellow'>C</span>onsultant</div></Link>
      <Link className='white' legacyBehavior href="/medical"><div className="col-6 col-md-3 section"><span className='bigChar blue' >M</span>edical</div></Link>
      <Link className='white' legacyBehavior href="/rent-car"><div className="col-6 col-md-2 section"><span className='bigChar red' >R</span>ent Car</div></Link>

      </div>
      <div className="row ">
      <Link className='white' legacyBehavior href="/realstate"><div className="col-6 col-md-3 section"><span className='bigChar orange' >R</span>eal Estate</div></Link>
      <Link className='white' legacyBehavior href="/services"><div className="col-6 col-md-2 section"><span className='bigChar green' >M</span>EP Services</div></Link>
      <Link className='white' legacyBehavior href="/industry"><div className="col-6 col-md-2 section"><span className='bigChar blue' >I</span>ndustry</div></Link>
      <Link className='white' legacyBehavior href="/oil-gas"><div className="col-6 col-md-3 section"><span className='bigChar ' >O</span>il & Gas</div></Link>
      <Link className='white' legacyBehavior href="/hotels"><div className="col-5 col-md-2 section"><span className='bigChar yellow' >H</span>otels</div></Link>

      </div>
    </div>
    <div className="container-fluid bg-about" id='aljaber'>
    <div className="row  ">
        <div className="col-md-12 ck-content">
          {data ?
            parse(data['attributes']['body'])
            : ''
          }
        </div>
      </div>
    </div>
    <div className="container-fluid home-projects bg-company" id='our'>
      <div className="row">
      <div className="col-md-3 home-project-title ">
        <h5>Russia</h5>
      
        <Link  href='#'>
            <div className="cart mt-50">
              <img  src='https://pixelfcty.com/uploads/logoes_09_03fd75b481.png'></img>
            </div>
            </Link>
      </div>
      <div className="col-md-3 home-project-title img-sm">
        <h5>Oman</h5>

          {
            companies?
            companies.map(company=>(
              company['attributes']['country'] == 'Oman'?
              <Link key={company['id']}  href={company['attributes']['external_link']?'https://'+company['attributes']['slug']:'/companies/'+company['attributes']['slug'].replaceAll('-',' ')} target={company['attributes']['external_link']?'_blank':''}>
            <div className="cart mt-5px">
              <img  src={'https://pixelfcty.com/'+company['attributes']['picture']['data']['attributes']['url']}></img>
            </div>
            </Link>:''
            
            )):''

          }

            
        </div>
      <div className="col-md-3 home-project-title img-sm">
        <h5>Syria</h5>

        {
            companies?
            companies.map(company=>(
              company['attributes']['country'] == 'Syria'?
              <Link key={company['id']}  href={company['attributes']['external_link']?'https://'+company['attributes']['slug']:'/companies/'+company['attributes']['slug'].replaceAll('-',' ')} target={company['attributes']['external_link']?'_blank':''}>
              <div className="cart mt-5px">
              <img  src={'https://pixelfcty.com/'+company['attributes']['picture']['data']['attributes']['url']}></img>
            </div>
            </Link>:''
            
            )):''

          }
        </div>
      <div className="col-md-3 home-project-title img-sm">
        <h5>UAE</h5>

        {
            companies?
            companies.map(company=>(
              company['attributes']['country'] == 'UAE'?
              <Link key={company['id']}  href={company['attributes']['external_link']?'https://'+company['attributes']['slug']:'/companies/'+company['attributes']['slug'].replaceAll('-',' ')} target={company['attributes']['external_link']?'_blank':''}>
              <div className="cart mt-5px">
              <img  src={'https://pixelfcty.com/'+company['attributes']['picture']['data']['attributes']['url']}></img>
            </div>
            </Link>:''
            
            )):''

          }
      </div>



      </div>
    </div>
    <div className="container-fluid counter-bg " id='counter'>
      <div className="row">
        <div className="counters">
          <div className="container">
            <div className="row">
              <div className=" col-12 col-md-2">
                <div className="counter">
                  <p> <CountUp end={4000} delay={1} duration={5}/>+ <br /> Happy Families Develope</p>
                </div>
              </div>
              <div className=" col-12 col-md-2">
                <div className="counter">
                  <p> <CountUp end={2000000} delay={1} duration={5}/>+ m<sup>2</sup> <br /> project</p>
                </div>
              </div>
              <div className=" col-12 col-md-2">
                <div className="counter">
                  <p><CountUp end={50000} delay={1} duration={5}/>+ m<sup>3</sup> <br /> Construction</p>
                </div>
              </div>
              <div className=" col-12 col-md-2">
                <div className="counter">
                  <p><CountUp end={20000000}delay={1} duration={5} />+ $ <br /> Invest</p>
                </div>
              </div>
              <div className=" col-12 col-md-2">
                <div className="counter">
                  <p><CountUp end={2500} delay={1} duration={5}/>+ <br /> Services</p>
                </div>
              </div>
              <div className=" col-12 col-md-2">
                <div className="counter">
                  <p> <CountUp end={8} delay={1} duration={5}/>+ <br /> Factories Industry</p>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
    <div id='footer'></div>
        <Footer/>
  </main>
      
    }
    </>

  )
}




export default Home;